/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.panel.stats;

import io.github.thecsdev.betterstats.client.gui.panel.stats.BSStatPanel;
import io.github.thecsdev.betterstats.client.gui.screen.BetterStatsScreen;
import io.github.thecsdev.betterstats.util.StatUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectEnumWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_3469;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class BSStatPanel_General
extends BSStatPanel {
    public BSStatPanel_General(TPanelElement parentToFill) {
        super(parentToFill);
    }

    public BSStatPanel_General(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public TSelectWidget createFilterSortByWidget(BetterStatsScreen bss, int x, int y, int width, int height) {
        TSelectEnumWidget sw = new TSelectEnumWidget(x, y, width, height, BSStatPanelGeneral_SortBy.class);
        sw.setSelected((Enum)bss.cache.getAs("BSStatPanelGeneral_SortBy", BSStatPanelGeneral_SortBy.class, (Object)BSStatPanelGeneral_SortBy.Default), false);
        sw.setEnumValueToLabel(newVal -> ((BSStatPanelGeneral_SortBy)((Object)newVal)).asText());
        sw.setOnSelectionChange(newVal -> {
            bss.cache.set("BSStatPanelGeneral_SortBy", newVal);
            bss.getStatPanel().init_stats();
        });
        return sw;
    }

    @Override
    public void init(BetterStatsScreen bss, class_3469 statHandler, Predicate<StatUtils.StatUtilsStat> statFilter) {
        ArrayList<StatUtils.StatUtilsGeneralStat> stats = StatUtils.getGeneralStats(statHandler, statFilter.and(this.getStatPredicate()));
        switch ((BSStatPanelGeneral_SortBy)((Object)bss.cache.getAs("BSStatPanelGeneral_SortBy", BSStatPanelGeneral_SortBy.class, (Object)BSStatPanelGeneral_SortBy.Default))) {
            case Reverse: {
                Collections.reverse(stats);
                break;
            }
            case Incremental: {
                Collections.sort(stats, (o1, o2) -> Integer.compare(o1.intValue, o2.intValue));
                break;
            }
            case Decremental: {
                Collections.sort(stats, (o1, o2) -> Integer.compare(o2.intValue, o1.intValue));
                break;
            }
        }
        Objects.requireNonNull(this.getTextRenderer());
        int height = 9 + 8;
        for (StatUtils.StatUtilsGeneralStat stat : stats) {
            new BSStatWidget_General(stat, height);
        }
        if (stats.size() == 0) {
            this.init_noResults();
        }
    }

    public int getChildBottomY() {
        if (this.getTChildren().size() == 0) {
            return this.getTpeY() + this.getScrollPadding();
        }
        return ((TElement)this.getTChildren().getTopmostElements().Item2).getTpeEndY() + 2;
    }

    public static enum BSStatPanelGeneral_SortBy {
        Default(TextUtils.literal((String)"A-Z")),
        Reverse(TextUtils.literal((String)"Z-A")),
        Incremental(TextUtils.literal((String)"0-9")),
        Decremental(TextUtils.literal((String)"9-0"));

        private final class_5250 text;

        private BSStatPanelGeneral_SortBy(class_5250 text) {
            this.text = text;
        }

        public class_5250 asText() {
            return this.text;
        }
    }

    protected class BSStatWidget_General
    extends BSStatPanel.BSStatWidget {
        public final StatUtils.StatUtilsGeneralStat stat;

        public BSStatWidget_General(StatUtils.StatUtilsGeneralStat stat, int height) {
            super(BSStatPanel_General.this.getTpeX() + BSStatPanel_General.this.getScrollPadding(), BSStatPanel_General.this.getChildBottomY(), BSStatPanel_General.this.getTpeWidth() - BSStatPanel_General.this.getScrollPadding() * 2, height);
            BSStatPanel_General.this.addTChild(this, false);
            this.stat = stat;
            this.updateTooltip();
        }

        @Override
        public void updateTooltip() {
            this.setTooltip(null);
        }

        @Override
        public void render(class_4587 matrices, int mouseX, int mouseY, float deltaTime) {
            super.render(matrices, mouseX, mouseY, deltaTime);
            this.drawTElementText(matrices, this.stat.label, HorizontalAlignment.LEFT, deltaTime);
            this.drawTElementText(matrices, (class_2561)this.stat.value, HorizontalAlignment.RIGHT, deltaTime);
        }
    }
}

